/* ------------------------------------------------------------------------ */
/*  @@ Source Documentation                            *** TC Version ***   */
/*                                                                          */
/*  Copyright (c) Creative Technology Pte Ltd, 1991. All rights reserved.   */
/*                                                                          */
/*   TITLE       : MIDIIN.C                                                 */
/*                                                                          */
/*   DESCRIPTION :                                                          */
/*       This program demostrates how to use the SBK MIDI interface         */
/*       functions to read in the MIDI code through DSP and display         */
/*       it on screen. The user can terminate the process by pressing       */
/*       ESC key.                                                           */
/*                                                                          */
/*       The program checks BLASTER environment for the Card settings.      */
/*       It also performs test base on BLASTER environment settings to      */
/*       ensure they are tally with the hardware settings on the Card.      */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include  <stdio.h>
#include  <bios.h>
#include  <sbc.h>
#include  <sbmidi.h>


main()
{
    long lMidiCode, lTimeStamp;
    unsigned char bMidiByte;


    /* Retrieve the BLASTER environment settings */
    if ( ! GetEnvSetting() )
    {
        if (sbc_check_card() & 4)
        {
            if (sbc_test_int())
            {
                /* Start input */
                sbmidi_start_input();

                while ( 1 )
                {
                    /*  Check for ESC key  */
                    if ( bioskey(1) )
                        if ( bioskey(0) == 0x11b)
                            break;

                    /*  Read the MIDI input from buffer */
                    if ( (lMidiCode = sbmidi_get_input()) != 0 )
                    {

                        bMidiByte = (unsigned char)(lMidiCode & 0x000000ff);
                        lTimeStamp = lMidiCode >> 8;

                        printf("\nMIDI Byte : %02x hex     ",bMidiByte);
                        printf("Time Stamp : %8lu msec", lTimeStamp);
                    }
                }


                /* Stop input */

                sbmidi_stop_input();


                /* read the remaining codes in the buffer */

                while ( (lMidiCode = sbmidi_get_input()) != 0 )
                {
                    bMidiByte = (unsigned char)(lMidiCode & 0x000000ff);
                    lTimeStamp = lMidiCode >> 8;

                    printf("\nMIDI Byte : %02x hex     ",bMidiByte);
                    printf("Time Stamp : %8lu msec", lTimeStamp);
                }
            }
            else
                printf("Error on interrupt.\n");
        }
        else
            printf("Sound Blaster Card not found or wrong I/O setting.\n") ;
    }
    else
        printf("BLASTER environment variable not set or incomplete or invalid.\n");
}

